<?php
include 'db.php';

header("Content-Type: application/json");

$response = ["status" => "error", "message" => "Invalid request"];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Read JSON input
    $json_data = file_get_contents("php://input");
    $data = json_decode($json_data, true);

    // Extract values safely
    $firstname = isset($data['firstname']) ? trim($data['firstname']) : '';
    $lastname = isset($data['lastname']) ? trim($data['lastname']) : '';
    $emailid = isset($data['emailid']) ? trim($data['emailid']) : '';
    $phone = isset($data['phone']) ? trim($data['phone']) : '';
    $pan = isset($data['pan']) ? trim($data['pan']) : '';
    $password = isset($data['password']) ? trim($data['password']) : '';
    $hasGst = isset($data['hasGst']) ? $data['hasGst'] : false;
    $gstnumber = $hasGst && isset($data['gstnumber']) ? trim($data['gstnumber']) : 'NULL';
    $companyname = $hasGst && isset($data['companyname']) ? trim($data['companyname']) : 'NULL';

    // Validate required fields
    if (empty($firstname) || empty($lastname) || empty($emailid) || empty($phone) || empty($pan)) {
        $response["message"] = "All fields are required!";
        echo json_encode($response);
        exit;
    }

    // Check if phone or email already exists
    $checkQuery = "SELECT * FROM customer WHERE phoneno = '" . mysqli_real_escape_string($conn, $phone) . "' OR email = '" . mysqli_real_escape_string($conn, $emailid) . "'";
    $checkResult = mysqli_query($conn, $checkQuery);

    if (mysqli_num_rows($checkResult) > 0) {
        $existingData = mysqli_fetch_assoc($checkResult);
        $response = [
            "status" => "exists",
            "message" => "Customer with this phone or email already exists",
            "customer" => [
                "id" => $existingData['id'],
                "displayname" => $existingData['displayname'],
                "email" => $existingData['email'],
                "phone" => $existingData['phoneno']
            ]
        ];
    } else {
        // Combine firstname and lastname
        $displayname = $firstname . " " . $lastname;

        // Handle NULL values for GST fields
        $gstnumberValue = ($hasGst && $gstnumber !== 'NULL') ? "'" . mysqli_real_escape_string($conn, $gstnumber) . "'" : 'NULL';
        $companynameValue = ($hasGst && $companyname !== 'NULL') ? "'" . mysqli_real_escape_string($conn, $companyname) . "'" : 'NULL';

        // Insert into customer table
        $query = "INSERT INTO customer 
                  (primarycontact, customertype, displayname, email, password, phoneno, pan_no, gstno, companyname) 
                  VALUES (
                      '" . mysqli_real_escape_string($conn, $firstname) . "',
                      1,
                      '" . mysqli_real_escape_string($conn, $displayname) . "',
                      '" . mysqli_real_escape_string($conn, $emailid) . "',
                      '" . mysqli_real_escape_string($conn, $password) . "',
                      '" . mysqli_real_escape_string($conn, $phone) . "',
                      '" . mysqli_real_escape_string($conn, $pan) . "',
                      " . $gstnumberValue . ",
                      " . $companynameValue . "
                  )";

        $result = mysqli_query($conn, $query);

        if ($result) {
            $customerId = mysqli_insert_id($conn);
            $response = [
                "status" => "success", 
                "message" => "User registered successfully",
                "customer" => [
                    "id" => $customerId,
                    "displayname" => $displayname,
                    "email" => $emailid,
                    "phone" => $phone
                ]
            ];
        } else {
            $response["message"] = "Failed to insert into customer: " . mysqli_error($conn);
        }
    }
}

echo json_encode($response);
?>